/*======================================================================================
   format_plugin_sample.c
======================================================================================
 $RCSfile: format_plugin_sample.c$
 $Revision:$
 $Date:$
 $Author:Will Huang$
 $Revision: $
======================================================================================

======================================================================================


---------------------------------------------------------------------------

  Module Description:
     Format Plugin sample.

---------------------------------------------------------------------------*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "hsm_plugin/matrix_barcodeid.h"
#include "hsm_plugin/matrix_plugin.h"
#include "hsm_plugin/matrix_format_plugin.h"
#include "hsm_plugin/matrix_beep_led.h"

/*===================================================================
 * Plug-in properties
 * Defined by user
 *
=====================================================================*/
#define PLUGIN_NAME SampleFormat
#define COMPANY_NAME Plug-In Developer, Inc.
#define MAJOR_VERSION	5
#define MONOR_VERSION	3
#define BUILD_NUMBER	37
#define CERTIFICATE		102148
#define CERTIFICATE_TIME	2009/08/10 15:00:05
#define PLUGIN_GUID	abcd1234
#define FILE_NAME		Format.plugin

#define MenuID	0x6B1F


/** This API is called to perform a data fromat.
 *  The plug-in developer should implement this
 *  routine by himself and set address of this 
 *  function to the "DataEdit" field of the 
 *  "DataEditApi" sturture.
 */
int MatrixPluginDataEdit(DataEditParam *pFormatParam)
{
	// Add your Format code here and copy the result back to pFormatParam->message.
	printf("\r\nMatrixPluginDataEdit\r\n");
	return 0;
}

/** This API is called when plug-in needs to configure itself by 
 *  scanning a specific menu barcode.
 */
int MatrixPluginProcessingBarcode(char *pMenuData, int DataLength)
{
	// Add your plugin menu processing code here and return 0 if succeed and -1 if fail, 
	// system will beeps error or success according to the return value
	printf("\r\nMatrixPluginProcessingBarcode\r\n");
	printf("Menu Data is: ");
	printf(pMenuData);
	printf("\r\n");
	beep_led_io(MenuDifferentBeepSeq, 6);
	return 0;
}

/** The MatrixPlulginCheckLicense API is used to validate if 
 *  the plug-in is licensed or not. This function will be called
 *  immediately when the plug-in is loaded. Plug-in should keep
 *  the result of the license validation during its runtime.If 
 *  the plug-in is not licensed, the plug-in must return -1 when
 *  any other API of it is called.
 */
int MatrixPlulginCheckLicense(char *SN)
{
	// Add your license validation code here
	// return 0 to indicate the plug-in is licensed
	// return -1 for not licensed
	printf("\r\nMatrixPlulginCheckLicense\r\n");
	printf("Serial Number: %s\r\n", SN);
	return 0;
}


/** Honeywell Gen.6 scanner use this API to retrieve plug-in
 *  Version information. The version information will be filled
 *  in the VersionInfo structure after the API returns
 *  successfully.
 */
int MatrixPluginGetVersion(VersionInfo *pInfo)
{
	// Add your Get version code here
	// Plugin should fill in the pInfo
	// with the plugin version info
	// return 0 for success and -1 for failure
	printf("\r\nMatrixPluginGetVersion\r\n");
	return 0;
}

/********************************************** 
   Format Plugin APIs definition 
   Fill the fields with 
   user defined APIs.
 *********************************************/
static DataEditApi apis = {
	.RevisionNumber = 1,
	.DataEdit = MatrixPluginDataEdit,
	.ProcessingBarcode = MatrixPluginProcessingBarcode,
	.CheckLicense = MatrixPlulginCheckLicense,
	.GetVersion = MatrixPluginGetVersion,
};


/**********************************************
   This is the initial function of plug-in
   This routine is user defined and be used
   to initilize plug-in and register plug-in
   APIs.
   Parameter:
   		plugin ---- Plug-in information structure
   Return Value:
   		-1 indicate a error and 0 to success
 *********************************************/
int init_plugin(HONPluginRawInfo *plugin)
{
	int ret = 0;
	void *testp = NULL;
	
	printf("/******************************/\r\n");
	printf("     Sample Format Plugin\r\n");
	printf("/******************************/\r\n");
	
	testp = malloc(900*1024);
	
	if(testp)
		printf("Malloc success\r\n");
	else
		printf("Malloc test done\r\n");
	
	ret = register_apis(plugin, &apis);
	if(ret){
		printf("Plugin APIs Registration Failed\r\n");
		return -1;
	}
	
	return 0;

}

/**********************************************
   This is the cleanup function of plug-in
   This routine is user defined and is used
   to cleanup plug-in when remove plug-in from
   system.
 *********************************************/
void cleanup_plugin(void)
{
	return;
}

/**********************************************
   We should declare the plug-in by using
   'DECLARE_PLUGIN' macro in order that 
   Matrix can recognize the plug-in
 *********************************************/
DECLARE_PLUGIN(init_plugin, cleanup_plugin, HON_PLUGIN_FORMAT, MenuID);

/*=================================================================================
                       File Modification History
===================================================================================
 $Log:$
===================================================================================*/


