/*=================================================================================
  Matrix beeper and led control.

  =================================================================================
   $Source: matrix_beep_led.h $
   $Author: Huang, Will (E374983) $
   $Date: $
   $Revision: $

   (c) Copyright Honeywell 2004-2008, All Rights Reserved
=================================================================================*/

#ifndef _MATRIX_BEEP_LED_H
#define _MATRIX_BEEP_LED_H

#include <hsm_plugin/matrix_plugin.h>

/** The GOODREAD and ERROR LED control is now maintained by the beeper
 *
 *			$ each sequence should start with a audible LED sync (LED_DEFINE) and end with a terminator (0x00).
 *			$ the Odd entries of the sequence are duration in heartbeats and the even entries are the frequency (0 is a rest).
 *			$ frequency 100 or above will be an audible sound (provided the beeper can create the sound)
 *			$ frequency 100 or above will use the LED specified at the first char of the sequence
 *			$ for each silent pause, use one of the LED defines as the frequency.
 *		unsigned int ExampleSeq[] = {audible LED sync (LED_DEFINE), duration of next freq (mS), audible freq (Hz),
 *																			duration (mS), silent freq (LED_DEFINE), end of string (0x00)};
 *
 *		unsigned int StandardClickSeq[] = {NO_LED, 10, 200, 10, NO_LED, 0x00};
 *		This sequence can be read as 10mS sound at 200Hz with no led, then 10mS silence with no led
 *
 *	NOTE the beeper duration has a resolution of 10ms.
 *	unsigned int StandardBeepSeq[]	={LED Synchronized?,mS (duration),frequency hz,end of string (0x00)};
 */
 
 
/**
 * LED dfines
 */
 #define NO_LED 0	            // These have to be Even numbers!  The odd value is used to select OFF timing.
#define GOOD_READ_LED 2
#define ERROR_LED 4

const unsigned int StandardBeepSeq[]=
{
        NO_LED,160,2720,0x00
};

/**
 * GOODREAD     --------------
 * BEEPER      |    80 mS     |_____60 mS_____|
 *
 * LED          --------------
 *             |    80 mS     |_____60 mS_____|
 */
const unsigned int GoodReadBeepSeq[]=	{GOOD_READ_LED,80,3250,60,NO_LED,0x00};


const unsigned int MenuReadBeepSeq[] =
{
        GOOD_READ_LED,100,1350,100,1800,0x00
};


const unsigned int ErrorBeepSeq[]	= {ERROR_LED,160,800,160,NO_LED,0x00};

const unsigned int MenuDifferentBeepSeq[]=
{
    	GOOD_READ_LED,300,1350,300,1800,0x00
};

const unsigned int OposBeepSeq[]   	=
    {
        GOOD_READ_LED,160,1632,160,1250,160,800,0x00
    };

#endif	/* _MATRIX_BEEP_LED_H */

/*=================================================================================
                       File Modification History
===================================================================================
 $Log: $
===================================================================================*/


