/*=================================================================================
  Matrix format plugin apis.

  =================================================================================
   $Source: matrix_format_plugin.h $
   $Author: Huang, Will (E374983) $
   $Date: $
   $Revision: 1.0 $

   (c) Copyright Honeywell 2004-2008, All Rights Reserved
=================================================================================*/

#ifndef _MATRIX_FORMAT_PLUGIN_H

#include <hsm_plugin/matrix_plugin.h>

typedef struct {
	/// Revision number
	int RevisionNumber;
	/// Output Data String
	unsigned char *message;
	/// Number of Data Characters
	int length;      				
	///Character size (1 for byte, 2 for word)
	int CharSize;					
	/// Hand Held Products internal Code (Symbology) ID
	char HHPcodeID;   			
	/// AIM/FACT/ISO "Symbology Identifier"
	char AIMcodeLetter;  			
	/// ... and "Modifier" character
	char AIMcodeModifier; 		
} DataEditParam;

typedef struct
{
	/// Revision Number
	int RevisionNumber;			
	/// Format API callback
	int (*DataEdit)(DataEditParam *pFormatParam);	
	/// Plug-in Menuing API callback 
	int (*ProcessingBarcode)(char *pMenuData, int DataLength);	
	/// Check license API callback
	int (*CheckLicense)(char *SN);		
	/// Get version API callback
	int (*GetVersion)(VersionInfo *pInfo);		
} DataEditApi;


/** This API is called to perform a data fromat.
 *  The plug-in developer should implement this
 *  routine by himself and set address of this 
 *  function to the "DataEdit" field of the 
 *  "DataEditApi" sturture.
 * \sa DataEditParam
 * \sa DataEditApi
 * \param pFormatParam			The pointer of the parameter struture 
 *												which is passed to the data edit API
 * \return int						0 indicates that the formatting operation has succeeded
 *												and -1 indicate that the operation failed. Note that
 *												various reasons may casued the operation failure, such 
 *												as not configuring the plug-in correctly, plug-in internal
 *												error or the plug-in's not licensed. The developer of plug-in
 *												should handle all these errors in his API and retrn -1 to
 *												scanner.
 */
extern int MatrixPluginDataEdit(DataEditParam *pFormatParam);

/** This API is called when plug-in needs to configure itself by 
 *  scanning a specific menu barcode.
 * \sa DataEditParam
 * \sa DataEditApi
 * \param pMenuData				Buffer pointer to the menu code data. 
 * \param DataLength			Buffer length of the menu code data.
 * \return int						0 indicates that the formatting operation has succeeded
 *												and -1 indicate that the operation failed. Note that
 *												various reasons may casued the operation failure, such 
 *												as not configuring the plug-in correctly, plug-in internal
 *												error or the plug-in's not licensed. The developer of plug-in
 *												should handle all these errors in his API and retrn -1 to
 *												scanner.
 */
extern int MatrixPluginProcessingBarcode(char *pMenuData, int DataLength);

/** The MatrixPlulginCheckLicense API is used to validate if 
 *  the plug-in is licensed or not. This function will be called
 *  immediately when the plug-in is loaded. Plug-in should keep
 *  the result of the license validation during its runtime.If 
 *  the plug-in is not licensed, the plug-in must return -1 when
 *  any other API of it is called.
 * \sa DataEditApi
 * \param SN							Pointer to serial number string. 
 * \return int						0 indicates that the formatting operation has succeeded
 *												and -1 indicate that the operation failed. Note that
 *												various reasons may casued the operation failure, such 
 *												as not configuring the plug-in correctly, plug-in internal
 *												error or the plug-in's not licensed. The developer of plug-in
 *												should handle all these errors in his API and retrn -1 to
 *												scanner.
 */
extern int MatrixPlulginCheckLicense(char *SN);


/** Honeywell Gen.6 scanner use this API to retrieve plug-in
 *  Version information. The version information will be filled
 *  in the VersionInfo structure after the API returns
 *  successfully.
 * \sa VersionInfo
 * \param Info						Pointer of the VersionInfo structure.
 * \return int						0 indicates that the formatting operation has succeeded
 *												and -1 indicate that the operation failed. Note that
 *												various reasons may casued the operation failure, such 
 *												as not configuring the plug-in correctly, plug-in internal
 *												error or the plug-in's not licensed. The developer of plug-in
 *												should handle all these errors in his API and retrn -1 to
 *												scanner.
 */
extern int MatrixPluginGetVersion(VersionInfo *pInfo);

#endif	/* _MATRIX_FORMAT_PLUGIN_H */

/*=================================================================================
                       File Modification History
===================================================================================
 $Log: $
===================================================================================*/


