/*=================================================================================
  ELF object file core definations.

  =================================================================================
   $Source: matrix_plugin.h $
   $Author: Huang, Will (E374983) $
   $Date: $
   $Revision: $

   (c) Copyright Honeywell 2004-2008, All Rights Reserved
=================================================================================*/

#ifndef _MATRIX_PLUGIN_H
#define _MATRIX_PLUGIN_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <hsm_plugin/matrix_syscalls.h>

#define PLUGIN_STRING_LEN (64)
#define PLUGIN_GUID_LEN		(256)

#define _STRINGTRANS(...)	#__VA_ARGS__
#define STRINGTRANS(x)		_STRINGTRANS(x)


/* Export symbol for loadable plugins */
#define EXPORT_SYMBOL(sym)				\
	extern typeof(sym) sym;					\
	static const char matrix_strtab_##sym[]			\
	__attribute__((section("matrix_symtab_strings")))		\
	= "matrix_" #sym;                    	\
	static const HONPluginSymbol matrix_symtab_##sym	\
	__attribute__((section("matrix_symtab"), unused))	\
	= { (unsigned long)&sym, matrix_strtab_##sym }



#define DECLARE_PLUGIN(init_plugin, cleanup_plugin, plugin_type, MenuID)           \
        HONPluginRawInfo _this_plugin                                  \
        __attribute__((section(".this_plugin"))) = {            \
        .PluginRawName = STRINGTRANS(PLUGIN_NAME),                                    \
        .PluginRawClassType = plugin_type,                                            \
        .PluginInitRoutine = (void*)init_plugin,                                           \
        .PluginExitRoutine = (void*)cleanup_plugin,                                       \
        .PluginApis = NULL,																											\
        .MenuIdentifier = MenuID,																								\
				.CompanyName = STRINGTRANS(COMPANY_NAME),																\
				.MajorVersionNumber = STRINGTRANS(MAJOR_VERSION),													\
				.MinorVersionNumber = STRINGTRANS(MONOR_VERSION),													\
				.BuildNumber = STRINGTRANS(BUILD_NUMBER),																\
				.CertificateNumber = STRINGTRANS(CERTIFICATE),													\
				.CertificateTime = STRINGTRANS(CERTIFICATE_TIME),														\
				.GUID = STRINGTRANS(PLUGIN_GUID),																				\
				.FileName = STRINGTRANS(FILE_NAME),																			\
        }


enum HONPluginClassType
{
	HON_PLUGIN_TYPE_UNKNOW = 0,
	HON_PLUGIN_FORMAT,
	HON_PLUGIN_IMAGE,
	HON_PLUGIN_DECODE
};

typedef struct{
	// Raw name in plugin binary
	char PluginRawName[PLUGIN_STRING_LEN];

	// Raw Class Type in plguin binary
	enum HONPluginClassType PluginRawClassType;
		
	// Startup function.
	int (*PluginInitRoutine)(void *Info);

	// Destruction function.
	void (*PluginExitRoutine)(void);

	/* Plugin APIs. This should be in this structure in order that the plugin could assign APIs' address here */
	void *PluginApis;
	
	/* This field is the identifier assigned from Hoenywell. Menu codes with the identifier prefix will be passed to 
	 * the corresponding plug-in */
	 int MenuIdentifier;
	
	/* Other plugin infos */
	char CompanyName[PLUGIN_STRING_LEN];
	char MajorVersionNumber[PLUGIN_STRING_LEN];
	char MinorVersionNumber[PLUGIN_STRING_LEN];
	char BuildNumber[PLUGIN_STRING_LEN];
	char CertificateNumber[PLUGIN_STRING_LEN];
	char CertificateTime[PLUGIN_STRING_LEN];
	char GUID[PLUGIN_GUID_LEN];
	char FileName[PLUGIN_STRING_LEN];
		
} HONPluginRawInfo;

typedef struct {
	/// Revision Number
	int RevisionNumber;
	/// GUID of the plug-in
	char *GUID;
	/// Plug-in name
	char *PluginName;
	/// Company name of the plug-in
	char *CompanyName;
	/// Major version number
	int MajorVersion;
	/// Minor version number
	int MinorVersion;
	/// Build number of the plug-in version
	int BuildNumber;
	/// Certificate number of the plug-in version
	char *CertificateNumber;
	/// Certificate time (yyyy/mm/dd hh:mm:ss)
	char *CertificateTime;
} VersionInfo;

typedef struct PluginSymbol{
	unsigned long Value;
	const char *Name;
} HONPluginSymbol __attribute__((__aligned__(8)));


#endif	/* _MATRIX_PLUGIN_H */

/*=================================================================================
                       File Modification History
===================================================================================
 $Log: $
 Revision 1.2 2009/08/04 16:06:28GMT+08:00 Huang, Will (E374983) 
 Plugin Framwork for format plugins by Will Huang
===================================================================================*/


