/*=================================================================================
  Symbology IDs

//=================================================================================
   $Source: barcodeid.h $
   $Author: Walczyk Jr, Joseph A (E412257) $
   $Date: 2008/12/16 15:12:07EST $
   $Revision:

   Copyright (C) Handheld Products, Inc. 2002
//=================================================================================*/
//! \file

#ifndef BARCODE_ID_H__03164A21_6A2C_443B_BCD9_B1B934C58593__INCLUDED_
#define BARCODE_ID_H__03164A21_6A2C_443B_BCD9_B1B934C58593__INCLUDED_


/////////////////////////////////////////////////////////////////////////////
// --------------------------------------------------
//
//	These define the Welch Allyn Code ID
//	(not all listed symbologies are or will be
//	implemented)
//	--------------------------------------------------

	#define WA_CODELETTER_CODABAR 'a'
	#define WA_CODELETTER_CODE39 'b'
	#define WA_CODELETTER_UPC 'c'
	#define WA_CODELETTER_EAN 'd'
	#define WA_CODELETTER_UPCE 'E'
	#define WA_CODELETTER_EAN8 'D'
	#define WA_CODELETTER_INTERLEAVED2OF5 'e'
	#define WA_CODELETTER_CODE2OF5 'f'
	#define WA_CODELETTER_MSI 'g'
	#define WA_CODELETTER_CODE11 'h'
	#define WA_CODELETTER_CODE93 'i'
	#define WA_CODELETTER_CODE128 'j'
	#define WA_CODELETTER_UCC128 'I'
	#define WA_CODELETTER_CODE49 'l'
	#define WA_CODELETTER_MATRIX2OF5 'm'
	#define WA_CODELETTER_PLESSEY 'n'
	#define WA_CODELETTER_CODE16K 'o'
	#define WA_CODELETTER_CHANNELCODE 'p'
	#define WA_CODELETTER_CHINESE_MATRIX2OF5 'q'
	#define WA_CODELETTER_PDF417 'r'
   #define WA_CODELETTER_MICROPDF 'R'
	#define WA_CODELETTER_STACKEDCHANNELCODE 's'
	#define WA_CODELETTER_TELEPEN 't'
	#define WA_CODELETTER_CODEZ 'u'
	#define WA_CODELETTER_CODE39BASE32 'w'
	#define WA_CODELETTER_RSS14 'y'
	#define WA_CODELETTER_RSSLIMITED 'y'
	#define WA_CODELETTER_RSSEXPANDED 'y'
	#define WA_CODELETTER_COMPOSITE 'y'
	#define WA_CODELETTER_MENU_RESPONSE '6'

	#define WA_CODELETTER_AZTEC	'z'
	#define WA_CODELETTER_DATAMATRIX	'w'
	#define WA_CODELETTER_MAXICODE	'x'
	#define WA_CODELETTER_QRCODE	's'
/* the code id we use for the No Read message (I just picked a number TJK) */
	#define	NR_CODEID				156

//***********************************************************
// Define the AIM code letters
//***********************************************************
	#define AIM_CODELETTER_CODABAR					'F'
	#define AIM_CODELETTER_CODE39						'A'
	#define AIM_CODELETTER_UPC							'E'
	#define AIM_CODELETTER_EAN							'E'
	#define AIM_CODELETTER_INTERLEAVED2OF5			'I'
	#define AIM_CODELETTER_CODE2OF5					'S'
	#define AIM_CODELETTER_MSI							'M'
	#define AIM_CODELETTER_CODE11						'H'
	#define AIM_CODELETTER_CODE128					'C'
	#define AIM_CODELETTER_MATRIX2OF5				'X'
	#define AIM_CODELETTER_PLESSEY					'P'
	#define AIM_CODELETTER_CHINESE_MATRIX2OF5		'X'
	#define AIM_CODELETTER_TELEPEN					'B'
	#define AIM_CODELETTER_OTHER						'X'
	#define AIM_CODELETTER_RSS14						'e'
	#define AIM_CODELETTER_RSSLIMITED				'e'
	#define AIM_CODELETTER_RSSEXPANDED				'e'
	#define AIM_CODELETTER_PDF417						'L'
	#define AIM_CODELETTER_NONBARCODE				'Z'
	#define AIM_CODELETTER_MICROPDF					'L'
	#define AIM_CODELETTER_RSS14						'e'
	#define AIM_CODELETTER_AZTEC						'z'
	#define AIM_CODELETTER_DATAMATRIX				'd'
	#define AIM_CODELETTER_MAXICODE					'U'
	#define AIM_CODELETTER_QRCODE						'Q'
	#define AIM_CODELETTER_CODE93						'G'

	#define AIM_CODEMODIFIER_DEFAULT					'0'


/////////////////////////////////////////////////////////////////////////////

#endif // BARCODE_ID_H__03164A21_6A2C_443B_BCD9_B1B934C58593__INCLUDED_

/* ==============================================================================
   RCS Log
   ==============================================================================

   $Log: barcodeid.h  $
   Revision 1.1 2008/12/16 15:12:07EST Walczyk Jr, Joseph A (E412257) 
   Initial revision
   Member added to project d:/MKS_IT/Gen6FoundationApp/Gen6FoundationApp/libraries/buffer_fifo_utils/shared_buffer_fifo_utils.pj
   Revision 1.7 2005/02/28 13:38:46EST FauthD 
   Added doxygen comments.
   Revision 1.6 2004/08/10 21:03:55CEST fauthd 
   Added a few more AimIDs.
   Revision 1.5 2004/07/09 13:08:06CEST fauthd
   Added AIM PDF417 and Non-barcode
   Revision 1.4 2003/07/29 21:43:42CEST livingj2
   Added NR Code Id.
   Revision 1.3 2003/05/02 10:19:36EDT walczykj
   un comment QR code definition (used in HHLC interface )
   Revision 1.2 2003/04/07 18:59:12EDT fauthd
   Added a few 2D HHP IDs
   Revision 1.1 2003/02/18 14:19:58CET fauthd
   Initial revision
   Member added to project d:/MKS_IT/Matrix/matrix.pj

   ============================================================================== */
