/*=================================================================================
  Matrix decode plugin apis.

  =================================================================================
   $Source: matrix_decode_plugin.h $
   $Author: Huang, Will (E374983) $
   $Date: $
   $Revision: 1.0 $

   (c) Copyright Honeywell 2004-2008, All Rights Reserved
=================================================================================*/

#ifndef _MATRIX_DECODE_PLUGIN_H
#define _MATRIX_DECODE_PLUGIN_H

#include <hsm_plugin/matrix_plugin.h>

typedef struct
{
	/// Revision Number
	int RevisionNumber;			
	/// Decode API callback
	int (*Decode)(unsigned char *pBuffer, int width, int height);
	/// Set Decoder Menu
	int (*SetDecoderMenu)(void *DecoderSetting);
	/// Plug-in Menuing API callback 
	int (*ProcessingBarcode)(char *pMenuData, int DataLength);	
	/// Check license API callback
	int (*CheckLicense)(char *SN);		
	/// Get version API callback
	int (*GetVersion)(VersionInfo *pInfo);
} DecodeApi;

typedef enum {
	DECODE_TYPE_FAST = 0,
	DECODE_TYPE_FULL = 1
} DecodeType_t;

typedef struct {
   signed int x;	// x-coordinate
   signed int y;	// y-coordinate
} Corner_t;

typedef struct {
	Corner_t Corners[4];
	int D_Corner;
	int PdfRows;
	int PdfCols;
} IQImgInfo_t;


typedef struct {
	unsigned char *message; // Output Data String
	int length;	 				// Number of Data Characters
	char menuFlag;				// Boolean: is this for Menuing Purposes
	char mustStop;				// Boolean: signals UnStructured Append result
	char lastRecord;			// Boolean: is this the final "Result" from the current decode?
	char HHPcodeID;			// Hand Held Products internal Code (Symbology) ID
	char AIMcodeLetter;		// AIM/FACT/ISO "Symbology Identifier"
	char AIMcodeModifier;	// ... and "Modifier" character
	DecodeType_t DecodeType;
	IQImgInfo_t IQImgInfo;
} DecodeResult;


/** This API is called when plug-in needs to configure itself by 
 *  scanning a specific menu barcode.
 * \sa DecodeApi
 * \param pMenuData					The pointer of the decoded menu data 
 *												which is passed to the Plugin
 * \return int						0 indicates succeeded and -1 indicate that the operation failed. Note that
 *												various reasons may casued the operation failure, such 
 *												as not configuring the plug-in correctly, plug-in internal
 *												error or the plug-in's not licensed. The developer of plug-in
 *												should handle all these errors in his API and retrn -1 to
 *												scanner.
 */
extern int MatrixPluginProcessingBarcode(char *pMenuData, int DataLength);

/** The MatrixPlulginCheckLicense API is used to validate if 
 *  the plug-in is licensed or not. This function will be called
 *  immediately when the plug-in is loaded. Plug-in should keep
 *  the result of the license validation during its runtime.If 
 *  the plug-in is not licensed, the plug-in must return -1 when
 *  any other API of it is called.
 * \param SN						Pointer to the serial number string. 
 * \return int						0 indicates success and -1 indicate that the operation failed. Note that
 *												various reasons may casued the operation failure, such 
 *												as not configuring the plug-in correctly, plug-in internal
 *												error or the plug-in's not licensed. The developer of plug-in
 *												should handle all these errors in his API and retrn -1 to
 *												scanner.
 */
extern int MatrixPlulginCheckLicense(char *SN);


/** Honeywell Gen.6 scanner use this API to retrieve plug-in
 *  Version information. The version information will be filled
 *  in the VersionInfo structure after the API returns
 *  successfully.
 * \sa VersionInfo
 * \param Info						Pointer of the VersionInfo structure.
 * \return int						0 indicates that the formatting operation has succeeded
 *												and -1 indicate that the operation failed. Note that
 *												various reasons may casued the operation failure, such 
 *												as not configuring the plug-in correctly, plug-in internal
 *												error or the plug-in's not licensed. The developer of plug-in
 *												should handle all these errors in his API and retrn -1 to
 *												scanner.
 */
extern int MatrixPluginGetVersion(VersionInfo *pInfo);

/** This API is called to decode the image captured by the scanner 
 * \sa DecodeApi
 * \param pBuffer					The pointer of the image buffer 
 * \param width						int, the width of captured image
 * \param height					int, the height of capured image
 * \return int						0 indicates succeeded and -1 indicate that the operation failed. Note that
 *												various reasons may casued the operation failure, such 
 *												as not configuring the plug-in correctly, plug-in internal
 *												error or the plug-in's not licensed. The developer of plug-in
 *												should handle all these errors in his API and retrn -1 to
 *												scanner.
 */
extern int MatrixPluginDecode(unsigned char *pBuffer, int width, int height);

#endif	/* _MATRIX_DECODE_PLUGIN_H */

/*=================================================================================
                       File Modification History
===================================================================================
 $Log: $
===================================================================================*/


