Attribute VB_Name = "IT4xxx"
Option Explicit

'       ߂liG[ԍj
Public Const IT4xxx_NORMAL_END As Long = 0
Public Const IT4xxx_ERR_NOTOPEN   As Long = -1
Public Const IT4xxx_ERR_FILE      As Long = -2
Public Const IT4xxx_ERR_TIMEOUT   As Long = -3
Public Const IT4xxx_ERR_CANCEL    As Long = -4
Public Const IT4xxx_ERR_PARAMETER As Long = -5
Public Const IT4xxx_ERR_COM       As Long = -6
Public Const IT4xxx_ERR_FULL      As Long = -7
Public Const IT4xxx_ERR_IMGRCV    As Long = -8
Public Const IT4xxx_ERR_OTHER     As Long = -99

' C[Wf[^M
Public Const IT4xxx_IMG_NOTEXECUTE As Long = 0
Public Const IT4xxx_IMG_RECEIVING  As Long = 1
Public Const IT4xxx_IMG_BUFFCLEAR  As Long = 2

'       |[gݒ
Public Const IT4xxx_BAUD_300      As Long = 0
Public Const IT4xxx_BAUD_600      As Long = 1
Public Const IT4xxx_BAUD_1200     As Long = 2
Public Const IT4xxx_BAUD_2400     As Long = 3
Public Const IT4xxx_BAUD_4800     As Long = 4
Public Const IT4xxx_BAUD_9600     As Long = 5
Public Const IT4xxx_BAUD_19200    As Long = 6
Public Const IT4xxx_BAUD_38400    As Long = 7
Public Const IT4xxx_BAUD_57600    As Long = 8
Public Const IT4xxx_BAUD_115200   As Long = 9

Public Const IT4xxx_PARITY_NONE   As Long = 0
Public Const IT4xxx_PARITY_EVEN   As Long = 1
Public Const IT4xxx_PARITY_ODD    As Long = 2

Public Const IT4xxx_STOPBIT_1     As Long = 0
Public Const IT4xxx_STOPBIT_2     As Long = 1

Public Const IT4xxx_DATABIT_7     As Long = 0
Public Const IT4xxx_DATABIT_8     As Long = 1

Public Const IT4xxx_FLOW_NONE     As Long = 0
Public Const IT4xxx_FLOW_XONXOFF  As Long = 1
Public Const IT4xxx_FLOW_RTSCTS   As Long = 2

' C[Wf[^MvgR
Public Const IT4xxx_PROTOCOL_2P   As Long = 2

'-------------------------------------------------------------------
'

Declare Function IT4xxx_PortOpen Lib "IT4xxx.dll" (ByVal Port As Long, ByVal baud As Long, _
                   ByVal DataBit As Long, ByVal StopBit As Long, ByVal parity As Long, _
                   ByVal FlowCtrl As Long) As Long
Declare Function IT4xxx_PortClose Lib "IT4xxx.dll" (ByVal ComId As Long) As Long

Declare Function IT4xxx_RecvStart Lib "IT4xxx.dll" (ByVal ComId As Long, ByVal Wnd As Long, ByVal MsgNo As Long) As Long
Declare Sub IT4xxx_RecvStop Lib "IT4xxx.dll" (ByVal ComId As Long)

Declare Function IT4xxx_RecvChk Lib "IT4xxx.dll" (ByVal ComId As Long) As Long

Declare Function IT4xxx_ResponseRecv Lib "IT4xxx.dll" (ByVal ComId As Long, ByVal RcvBuffer As String, ByVal BufSize As Long) As Long
Declare Function IT4xxx_DataRecv Lib "IT4xxx.dll" (ByVal ComId As Long, ByVal RcvBuffer As String, ByVal BufSize As Long, _
                   ByVal PreFix As String, ByVal PostFix As String) As Long
Declare Function IT4xxx_ImageRecv Lib "IT4xxx.dll" (ByVal ComId As Long, ByVal Filename As String, _
                   ByVal RcvBuffer As String, ByVal BufSize As Long, ByVal Protocol As Long) As Long

Declare Function IT4xxx_DataSend Lib "IT4xxx.dll" (ByVal ComId As Long, ByVal WriteData As String, ByVal WriteCnt As Long) As Long
Declare Function IT4xxx_CmndSend Lib "IT4xxx.dll" (ByVal ComId As Long, ByVal Cmnd As String, ByVal SendCnt As Long) As Long

Declare Sub IT4xxx_TimeoutSet Lib "IT4xxx.dll" (ByVal ComId As Long, ByVal Wait As Long, ByVal Interval As Long)
Declare Sub IT4xxx_ComCancel Lib "IT4xxx.dll" (ByVal ComId As Long)

Declare Sub IT4xxx_ComClear Lib "IT4xxx.dll" (ByVal ComId As Long)
Declare Function IT4xxx_ImageProgress Lib "IT4xxx.dll" (ByVal ComId As Long, ByRef ImgSize As Long, ByRef ImgRecv As Long) As Long



'-------------------------------------------------------------------
'       VBp

Function vbIT4xxx_ResponseRecv(ByVal ComId As Long, ByRef RcvBuffer As String, ByVal BufSize As Long) As Long
    Dim Leng As Integer
    
    RcvBuffer = Space(BufSize)
    Leng = IT4xxx_ResponseRecv(ComId, RcvBuffer, BufSize)
    If Leng > 0 Then
        RcvBuffer = Left(RcvBuffer, Leng)
    Else
        RcvBuffer = ""
    End If
    
    vbIT4xxx_ResponseRecv = Leng
End Function

Function vbIT4xxx_DataRecv(ByVal ComId As Long, ByRef RcvBuffer As String, ByVal BufSize As Long, _
                   ByVal PreFix As String, ByVal PostFix As String) As Long
    Dim Leng As Integer
    
    RcvBuffer = Space(BufSize)
    Leng = IT4xxx_DataRecv(ComId, RcvBuffer, BufSize, PreFix + vbNullChar, PostFix + vbNullChar)
    If Leng > 0 Then
        RcvBuffer = Left(RcvBuffer, Leng)
    Else
        RcvBuffer = ""
    End If

    vbIT4xxx_DataRecv = Leng
End Function

Function vbIT4xxx_ImageRecv(ByVal ComId As Long, ByVal Filename As String, _
                   ByRef RcvBuffer As String, ByVal BufSize As Long, ByVal Protocol As Long) As Long
    Dim Leng As Integer

    RcvBuffer = Space(BufSize)
    Leng = IT4xxx_ImageRecv(ComId, Filename + vbNullChar, RcvBuffer, BufSize, Protocol)
    If Leng > 0 Then
        RcvBuffer = Left(RcvBuffer, Leng)
    Else
        RcvBuffer = ""
    End If
    
    vbIT4xxx_ImageRecv = Leng
End Function

Function vbIT4xxx_DataSend(ByVal ComId As Long, ByVal WriteData As String) As Long
    vbIT4xxx_DataSend = IT4xxx_DataSend(ComId, WriteData, Len(WriteData))
End Function

Function vbIT4xxx_CmndSend(ByVal ComId As Long, ByVal Cmnd As String) As Long
    vbIT4xxx_CmndSend = IT4xxx_CmndSend(ComId, Cmnd, Len(Cmnd))
End Function


