Option Strict Off
Option Explicit On
Module IT4xxx
	
	'       ߂liG[ԍj
	Public Const IT4xxx_NORMAL_END As Integer = 0
	
	Public Const IT4xxx_ERR_NOTOPEN As Integer = -1
	Public Const IT4xxx_ERR_FILE As Integer = -2
	Public Const IT4xxx_ERR_TIMEOUT As Integer = -3
	Public Const IT4xxx_ERR_CANCEL As Integer = -4
	Public Const IT4xxx_ERR_PARAMETER As Integer = -5
	Public Const IT4xxx_ERR_COM As Integer = -6
	Public Const IT4xxx_ERR_FULL As Integer = -7
	Public Const IT4xxx_ERR_IMGRCV As Integer = -8
	Public Const IT4xxx_ERR_OTHER As Integer = -99
	
	' C[Wf[^M
	Public Const IT4xxx_IMG_NOTEXECUTE As Integer = 0
	Public Const IT4xxx_IMG_RECEIVING As Integer = 1
	Public Const IT4xxx_IMG_BUFFCLEAR As Integer = 2
	
	'       |[gݒ
	Public Const IT4xxx_BAUD_300 As Integer = 0
	Public Const IT4xxx_BAUD_600 As Integer = 1
	Public Const IT4xxx_BAUD_1200 As Integer = 2
	Public Const IT4xxx_BAUD_2400 As Integer = 3
	Public Const IT4xxx_BAUD_4800 As Integer = 4
	Public Const IT4xxx_BAUD_9600 As Integer = 5
	Public Const IT4xxx_BAUD_19200 As Integer = 6
	Public Const IT4xxx_BAUD_38400 As Integer = 7
	Public Const IT4xxx_BAUD_57600 As Integer = 8
	Public Const IT4xxx_BAUD_115200 As Integer = 9
	
	Public Const IT4xxx_PARITY_NONE As Integer = 0
	Public Const IT4xxx_PARITY_EVEN As Integer = 1
	Public Const IT4xxx_PARITY_ODD As Integer = 2
	
	Public Const IT4xxx_STOPBIT_1 As Integer = 0
	Public Const IT4xxx_STOPBIT_2 As Integer = 1
	
	Public Const IT4xxx_DATABIT_7 As Integer = 0
	Public Const IT4xxx_DATABIT_8 As Integer = 1
	
	Public Const IT4xxx_FLOW_NONE As Integer = 0
	Public Const IT4xxx_FLOW_XONXOFF As Integer = 1
	Public Const IT4xxx_FLOW_RTSCTS As Integer = 2

    ' C[Wf[^MvgR
	Public Const IT4xxx_PROTOCOL_2P   As Integer = 2
	
	'-------------------------------------------------------------------
	'
	
	Declare Function IT4xxx_PortOpen Lib "IT4xxx.dll" (ByVal Port As Integer, ByVal baud As Integer, ByVal DataBit As Integer, ByVal StopBit As Integer, ByVal parity As Integer, ByVal FlowCtrl As Integer) As Integer
	Declare Function IT4xxx_PortClose Lib "IT4xxx.dll" (ByVal ComId As Integer) As Integer
	
	Declare Function IT4xxx_RecvStart Lib "IT4xxx.dll" (ByVal ComId As Integer, ByVal Wnd As Integer, ByVal MsgNo As Integer) As Integer
	Declare Sub IT4xxx_RecvStop Lib "IT4xxx.dll" (ByVal ComId As Integer)
	
	Declare Function IT4xxx_RecvChk Lib "IT4xxx.dll" (ByVal ComId As Integer) As Integer
	
	Declare Function IT4xxx_ResponseRecv Lib "IT4xxx.dll" (ByVal ComId As Integer, ByVal RcvBuffer As String, ByVal BufSize As Integer) As Integer
	Declare Function IT4xxx_DataRecv Lib "IT4xxx.dll" (ByVal ComId As Integer, ByVal RcvBuffer As String, ByVal BufSize As Integer, ByVal PreFix As String, ByVal PostFix As String) As Integer
	Declare Function IT4xxx_ImageRecv Lib "IT4xxx.dll" (ByVal ComId As Integer, ByVal Filename As String, ByVal RcvBuffer As String, ByVal BufSize As Integer, ByVal Protocol As Integer) As Integer
	
	Declare Function IT4xxx_DataSend Lib "IT4xxx.dll" (ByVal ComId As Integer, ByVal WriteData As String, ByVal WriteCnt As Integer) As Integer
	Declare Function IT4xxx_CmndSend Lib "IT4xxx.dll" (ByVal ComId As Integer, ByVal Cmnd As String, ByVal SendCnt As Integer) As Integer
	
	Declare Sub IT4xxx_TimeoutSet Lib "IT4xxx.dll" (ByVal ComId As Integer, ByVal Wait As Integer, ByVal Interval As Integer)
	Declare Sub IT4xxx_ComCancel Lib "IT4xxx.dll" (ByVal ComId As Integer)
	
	Declare Sub IT4xxx_ComClear Lib "IT4xxx.dll" (ByVal ComId As Integer)
	Declare Function IT4xxx_ImageProgress Lib "IT4xxx.dll" (ByVal ComId As Integer, ByRef ImgSize As Integer, ByRef ImgRecv As Integer) As Integer
	
	
	
	'-------------------------------------------------------------------
	'       VBp
	
	Function vbIT4xxx_ResponseRecv(ByVal ComId As Integer, ByRef RcvBuffer As String, ByVal BufSize As Integer) As Integer
		Dim Leng As Short
		
		RcvBuffer = Space(BufSize)
		Leng = IT4xxx_ResponseRecv(ComId, RcvBuffer, BufSize)
		If Leng > 0 Then
			RcvBuffer = Left(RcvBuffer, Leng)
		Else
			RcvBuffer = ""
		End If
		
		vbIT4xxx_ResponseRecv = Leng
	End Function
	
	Function vbIT4xxx_DataRecv(ByVal ComId As Integer, ByRef RcvBuffer As String, ByVal BufSize As Integer, ByVal PreFix As String, ByVal PostFix As String) As Integer
		Dim Leng As Short
		
		RcvBuffer = Space(BufSize)
		Leng = IT4xxx_DataRecv(ComId, RcvBuffer, BufSize, PreFix & vbNullChar, PostFix & vbNullChar)
		If Leng > 0 Then
			RcvBuffer = Left(RcvBuffer, Leng)
		Else
			RcvBuffer = ""
		End If
		
		vbIT4xxx_DataRecv = Leng
	End Function
	
	Function vbIT4xxx_ImageRecv(ByVal ComId As Integer, ByVal Filename As String, ByRef RcvBuffer As String, ByVal BufSize As Integer, ByVal Protocol As Integer) As Integer
		Dim Leng As Short
		
		RcvBuffer = Space(BufSize)
		Leng = IT4xxx_ImageRecv(ComId, Filename & vbNullChar, RcvBuffer, BufSize, Protocol)
		If Leng > 0 Then
			RcvBuffer = Left(RcvBuffer, Leng)
		Else
			RcvBuffer = ""
		End If
		
		vbIT4xxx_ImageRecv = Leng
	End Function
	
	Function vbIT4xxx_DataSend(ByVal ComId As Integer, ByVal WriteData As String) As Integer
		vbIT4xxx_DataSend = IT4xxx_DataSend(ComId, WriteData, Len(WriteData))
	End Function
	
	Function vbIT4xxx_CmndSend(ByVal ComId As Integer, ByVal Cmnd As String) As Integer
		vbIT4xxx_CmndSend = IT4xxx_CmndSend(ComId, Cmnd, Len(Cmnd))
	End Function
End Module